/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.MiscGlobals;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.mixin.IELevelStorageAccess_Misc;

public class MiscHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson gson;

    public static <T> MappedRegistry<T> filterAndCopyRegistry(MappedRegistry<T> registry, BiPredicate<ResourceKey<T>, T> predicate) {
        MappedRegistry newRegistry = new MappedRegistry(registry.m_123023_(), registry.m_203658_());
        for (Map.Entry entry : registry.m_6579_()) {
            Object object = entry.getValue();
            ResourceKey key = (ResourceKey)entry.getKey();
            if (!predicate.test((ResourceKey<ResourceKey>)key, (ResourceKey)object)) continue;
            newRegistry.m_255290_(key, object, registry.m_6228_(object));
        }
        return newRegistry;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void executeOnRenderThread(Runnable runnable) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_18695_()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on render thread", (Throwable)e);
            }
        } else {
            client.execute(runnable);
        }
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)MiscGlobals.refMinecraftServer.get();
    }

    public static void executeOnServerThread(Runnable runnable) {
        MinecraftServer server = MiscHelper.getServer();
        if (server.m_18695_()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on server thread", (Throwable)e);
            }
        } else {
            server.execute(runnable);
        }
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static Path getWorldSavingDirectory() {
        MinecraftServer server = MiscHelper.getServer();
        Validate.notNull((Object)server);
        Path saveDir = ((IELevelStorageAccess_Misc)((IEMinecraftServer_Misc)server).ip_getStorageSource()).ip_getLevelPath().f_230850_();
        return saveDir;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(new TypeToken<ResourceKey<Level>>(){}.getType(), (Object)new DimensionIDJsonAdapter());
        gson = gsonBuilder.create();
    }

    private static class DimensionIDJsonAdapter
    implements JsonSerializer<ResourceKey<Level>>,
    JsonDeserializer<ResourceKey<Level>> {
        private DimensionIDJsonAdapter() {
        }

        public ResourceKey<Level> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String str = json.getAsString();
            return DimId.idToKey(str);
        }

        public JsonElement serialize(ResourceKey<Level> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.m_135782_().toString());
        }
    }
}

